%     NITOOL     NATURE INSPIRED TOOLBOX

% ======================================================
%   PROGRAM AIM :
%         TO RUN FOR EVOLUTION
% ======================================================
%   USAGE :
%         1. runnit(nit, iSwarm)
% ==============================================
%   SATVIR SINGH SIDHU, ARUN KHOSLA, JASBIR SINGH SAINI
%   JULY 2009
%   COPYRIGHT RESERVED
% ==============================================

function RESULT = runnit(nit, iSwarm)
global RESULT
RESULT = [];

% LOOK FOR PLOT FIGURE IF AVAILABLE
% =========================
figPlot = findobj(0, 'Type', 'Figure', 'Name', ['NIT Plots: ' nit.Name]);
thisnit{1} = nit;

if ~isempty(figPlot)
    delete(figPlot);
end
figPlot = figure( ...
    'Name', ['NIT Plots: ' nit.Name], ...
    'NumberTitle', 'off', ...
    'Color', [0.9 0.9 0.9], ...
    'CloseRequestFcn', 'delete(gcf)',...
    'IntegerHandle', 'off',...
    'Visible', 'on', ...
    'MenuBar', 'none', ...
    'UserData', thisnit, ...
    'Units', 'pixels', ...
    'DefaultAxesXColor', 'black', ...
    'DefaultAxesYColor', 'black', ...
    'Position', [665 200 400 473], ...
    'Tag', 'nitPlot', ...
    'ButtonDownFcn', '', ...
    'KeyPressFcn', '', ...
    'DockControls', 'off');
xPlot = axes('Units', 'Normalized',...
    'FontSize', 8,...
    'FontName', 'Verdana',...
    'Position', [0.12 0.1 0.8 0.8],...
    'Box', 'On',...
    'Tag', 'NIGraph',...
    'XGrid', 'On',...
    'YGrid', 'On');
uicontrol('Units', 'Normalized',...
    'Style', 'Text',...
    'FontSize', 8,...
    'FontWeight', 'Bold',...
    'FontName', 'Verdana',...
    'Position', [0.63 0.70 0.25 0.03],...
    'BackGroundColor', [1 1 1],...
    'String', 'GBest Fitness');
GBTxt = uicontrol('Units', 'Normalized',...
    'Style', 'Text',...
    'FontSize', 8,...
    'FontWeight', 'Normal',...
    'FontName', 'Verdana',...
    'Position', [0.63 0.67 0.25 0.03],...
    'BackGroundColor', [1 1 1],...
    'ForeGroundColor', 'r',...
    'Tag', 'GBTEX',...
    'String', '...',...
    'Visible', 'On');

% PARTICLE SWARM OPTIMIZATION
% ======================
if strcmp(nit.Type, 'PSO')
    % Swarm
    psoModel = nit.Swarm.Model;
    NSize = nit.Swarm.NSize;
    Topology = nit.Swarm.Topology;

    % Objective Function
    ObjFun = nit.Objective.Function;

    % PSO Parameters
    C1 = nit.Parameter.C1;                                  % C1
    C2 = nit.Parameter.C2;                                  % C2
    C3 = nit.Parameter.C3;                                  % C3
    MaxVel = nit.Parameter.MaxVelocity;          % Maximum Velocity Check
    Chi = nit.Parameter.Chi;                                % Constriction Factor Chi
    WtOpt = nit.Parameter.WeightOption;       % Weight Option: 'Fixed' or 'Variable'
    StartWt = nit.Parameter.StartWeight;             % Starting Weight Value
    EndWt = nit.Parameter.EndWeight;               % End Weight Value

    TrgData = xlsread(nit.Objective.File, nit.Objective.Sheet, nit.Objective.Range);
    
    % PSO Run Termination Criteria
    NoChange = nit.Terminate.NoChange;       % No Change Fitness Iterations
    Goal = nit.Terminate.Goal;              % Minimum Acceptable Error
    MaxItr = nit.Terminate.MaxIterations;       % Maximum Number of iteration to be run

    % INITIAL PARAMETERS
    % ==============
    ItrNo = 1; success = 0; NCItr = 1;
    PSize = size(iSwarm, 1);
    Swarm = iSwarm;
    PBest = Swarm;
    PBestFit = feval(ObjFun, PBest);
    AvgFit(ItrNo) = mean(PBestFit);
    [GBFitVal, GBNo] = min(PBestFit);
    GBestFit(ItrNo) = GBFitVal;
    GBest = PBest(GBNo, :);

    % START PSO LOOP FROM HERE
    % ====================
    while success == 0
        % INITIAL, RANDOM & LIMITED VELOCITIES
        % ===========================
        Vel = MaxVel*rand(size(PBest));

        % INERTIA WEIGHTS
        % ============
        if strcmp(WtOpt, 'Fixed')
            Wt = StartWt;
        elseif strcmp(WtOpt, 'Variable')
            Wt = (EndWt - StartWt)*ItrNo/MaxItr;
        end

        % LBEST AND RING TOPOLOGY
        % ====================
        if strcmp(psoModel, 'LBest') & strcmp(Topology, 'Ring')
            for n = 1:PSize
                m = n-NSize:n+NSize;
                mem = mod(m, PSize);
                Group(n, :) = mem;
            end
            Group(find(Group==0)) = PSize;
            for n = 1:PSize
                for m = 1:2*NSize+1
                    LSwarm(m, :, n) = PBest(Group(n, m), :);
                end
                LSwarmFit(n, :) = feval(ObjFun, LSwarm(:, :, n));
                [LBestFit(n, ItrNo) LBNo(n)] = min(LSwarmFit(n, :));
                LBest(n, :) = LSwarm(LBNo(n), :, n);
            end
            
            GBestMat = repmat(GBest, PSize, 1);
            R1 = rand(size(Swarm)); R2 = rand(size(Swarm)); R3 = rand(size(Swarm));
            Vel = Wt*Vel + C1*R1.*(PBest-Swarm) + C2*R2.*(GBestMat-Swarm) + C3*R3.*(LBest-Swarm);
            
        % LBEST AND LINEAR TOPOLOGY
        % ====================
        elseif strcmp(psoModel, 'LBest') & strcmp(Topology, 'Linear')
            for n = 1:PSize
                m = n-NSize:n+NSize;
                mem = mod(m, PSize);
                Grp(n, :) = mem;
            end
            Group = Grp(NSize+1:PSize-NSize, :);
            Group(find(Group==0)) = PSize;
            for n = 1:PSize-2*NSize
                for m = 1:2*NSize+1
                    LSwarm(m, :, n) = PBest(Group(n, m), :);
                end
                LSwarmFit(n, :) = feval(ObjFun, LSwarm(:, :, n));
                [LBestFit(n, ItrNo) LBNo(n)] = min(LSwarmFit(n, :));
                LBest(n, :) = LSwarm(LBNo(n), :, n);
            end
            ZeMat = zeros(NSize, size(Swarm, 2));
            LBestMat = [ZeMat; LBest; ZeMat];
            GBestMat = repmat(GBest, PSize, 1);
            R1 = rand(size(Swarm)); R2 = rand(size(Swarm)); R3 = rand(size(Swarm));
            Vel = Wt*Vel + C1*R1.*(PBest-Swarm) + C2*R2.*(GBestMat-Swarm) + C3*R3.*(LBestMat-Swarm);
        
        % LBEST AND WHEEL TOPOLOGY
        % ====================
        elseif strcmp(psoModel, 'LBest') & strcmp(Topology, 'Wheel')
            'Wheel'
        
        % GBEST
        % ====================
        elseif strcmp(psoModel, 'GBest')
            GBestMat = repmat(GBest, PSize, 1);            
            R1 = rand(size(Swarm)); R2 = rand(size(Swarm));
            Vel = Wt*Vel + C1*R1.*(PBest-Swarm) + C2*R2.*(GBestMat-Swarm);
        end

        % LIMIT VELOCITEIS WITH [-MaxVel +MaxVel]
        % =============================
        locat = Vel > MaxVel;
        Vel(find(locat)) = MaxVel;
        locat = Vel < -MaxVel;
        Vel(find(locat)) = -MaxVel;
        
        % CALCULATE NEW Swarm
        % ================
        Swarm = Swarm + Chi * Vel;

        % CALCULATE Swarm FITNESS
        % ===================
        SwarmFit = feval(ObjFun, Swarm);

        % UPDATE PBEST ON IMPROVEMENT
        % ======================
        FindParticle = SwarmFit < PBestFit;
        PBestFit(find(FindParticle)) = SwarmFit(find(FindParticle));
        PBest(find(FindParticle), :) = Swarm(find(FindParticle), :);

        ItrNo = ItrNo + 1;

        % RECORD AVERAGE FITNESS
        % ==================
        AvgFit(ItrNo) = mean(PBestFit);
        
        % UPDATE GBEST ON IMPROVEMENT
        % ======================
        [GBFitVal, GBNo] = min(PBestFit);
        if GBFitVal < GBestFit(ItrNo-1)
            GBest = PBest(GBNo, :);
            GBestFit(ItrNo) = GBFitVal;
        else
            GBestFit(ItrNo) = GBestFit(ItrNo-1);
        end
        if GBFitVal == GBestFit(ItrNo-1)
            NCItr = NCItr + 1;
        else
            NCItr = 1;
        end

        % FURNISH NIT PLOT FIGURE
        % ==================
        a = num2str(nit.Plot.GBest);
        b = num2str(nit.Plot.Average);
        c = num2str(nit.Plot.LBest);
        plot(xPlot, 1:ItrNo, GBestFit, 'r', 1:ItrNo, AvgFit, 'b');
        switch [a b c] % PLOTS & LEGENDS REQUIRED
            case '001'
                plot(xPlot, 1:ItrNo, LBestFit, 'g');
                Lgd = legend(xPlot, 'Location', 'NorthEast', 'Local Best');
            case '010'
                plot(xPlot, 1:ItrNo, AvgFit, 'b');
                Lgd = legend(xPlot, 'Location', 'NorthEast', 'Average');
            case '011'
                plot(xPlot, 1:ItrNo, AvgFit, 'b', 1:ItrNo, LBestFit, 'g');                
                Lgd = legend(xPlot, 'Location', 'NorthEast', 'Average', 'Local Best');
            case '100'
                plot(xPlot, 1:ItrNo, GBestFit, 'r');                
                Lgd = legend(xPlot, 'Location', 'NorthEast', 'Global Best');
            case '101'
                plot(xPlot, 1:ItrNo, GBestFit, 'r', 1:ItrNo, LBestFit, 'g');                
                Lgd = legend(xPlot, 'Location', 'NorthEast', 'Global Best', 'Local Best');
            case '110'
                plot(xPlot, 1:ItrNo, GBestFit, 'r', 1:ItrNo, AvgFit, 'b');                
                Lgd = legend(xPlot, 'Location', 'NorthEast', 'Global Best', 'Average');
            case '111'
                plot(xPlot, 1:ItrNo, GBestFit, 'r', 1:ItrNo, AvgFit, 'b', 1:ItrNo, LBestFit, 'g');                
                Lgd = legend(xPlot, 'Location', 'NorthEast', 'Global Best', 'Average', 'Local Best');
        end

        set(xPlot, 'XGrid', 'On',...
            'YGrid', 'On',...
            'Box', 'On',...
            'XLim', [1 MaxItr]);
        Xl = xlabel(xPlot, 'Iterations',...
            'FontName', 'Verdana',...
            'FontSize', 10);
        Yl = ylabel(xPlot, 'Fitness',...
            'FontName', 'Verdana',...
            'FontSize', 10);
        Ttl = title(xPlot, 'PROGRESS GRAPHS',...
            'FontName', 'Verdana',...
            'FontSize', 10,...
            'FontWeight', 'Bold');

        set(GBTxt, 'String', num2str(GBestFit(ItrNo), '%10.3e'));
        
        % CRITERIA TO END LOOP
        % ================
        if NCItr == NoChange
            success = 1; 'NO CHANGE'
            assignin('base', 'GBest', GBest)
        elseif feval(ObjFun, GBest) == Goal
            success = 1; 'GOAL ACHIEVED'
            assignin('base', 'GBest', GBest)
        elseif ItrNo == MaxItr
            success = 1; 'MAX ITERATION'
            assignin('base', 'GBest', GBest)
        end
        pause(0.001)
    end
    % PSO LOOP TERMINATES HERE
    % ====================
elseif strcmp(nit.Type, 'GA')
    % GA LOOP
    RESULT = 0;

elseif strcmp(nit.Type, 'ACO')
    % ACO LOOP
    result = 0;

elseif strcmp(nit.Type, 'BBO')
    % BBO LOOP
    RESULT = 0;
end

